/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;

public class notebook
extends Panel {
    private Vector tabs;
    private Vector bgColors;
    private Vector fgColors;
    private Vector counts;
    private Vector verifierList;
    private Vector pageNames;
    private Vector components;
    private nbsimplelook renderer;
    private int pageCounter;
    private int currentTab;
    private int currentPage;
    private CardLayout layout;
    private int side;
    private int look;
    private int lastTop = -1;
    private hotspot hsList;
    private hotspot clicked;
    protected static final int Tab_Click = 0;
    protected static final int Up_Click = 1;
    protected static final int Down_Click = 2;
    protected static final int Page_Backward = 3;
    protected static final int Page_Forward = 4;
    public static final int Top = 0;
    public static final int Left = 1;
    public static final int Right = 2;
    public static final int Bottom = 3;
    public static final int Simple = 0;
    public static final int Spiral = 1;
    public static final int Bound = 2;
    public static final String Separator = ".";

    public notebook(int n, int n2) {
        this.setSideAndLook(n, n2);
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.setBackground(Color.lightGray);
        this.tabs = new Vector(10, 5);
        this.bgColors = new Vector(10, 5);
        this.fgColors = new Vector(10, 5);
        this.counts = new Vector(10, 5);
        this.verifierList = new Vector(10, 5);
        this.pageNames = new Vector(10, 5);
        this.components = new Vector(10, 5);
        this.currentTab = 0;
        this.pageCounter = 0;
        this.setOrientationAndStyle(n, n2);
        this.hsList = null;
    }

    public void setOrientation(int n) {
        this.setOrientationAndStyle(n, this.look);
    }

    public int getOrientation() {
        return this.side;
    }

    public void setStyle(int n) {
        this.setOrientationAndStyle(this.side, n);
    }

    public int getStyle() {
        return this.look;
    }

    public void setOrientationAndStyle(int n, int n2) {
        this.setSideAndLook(n, n2);
        this.renderer = new nbsimplelook(this);
        this.currentPage = 1;
        this.buildStatusBar();
        if (this.tabs.size() != 0) {
            this.rearrainge();
        }
    }

    private void setSideAndLook(int n, int n2) {
        switch (n2) {
            case 0: {
                if (n == 0 || n == 1 || n == 2 || n == 3) break;
                throw new IllegalArgumentException("Invalid position for Simple style");
            }
            case 1: {
                if (n == 2 || n == 3) break;
                throw new IllegalArgumentException("Invalid position for Spiral style");
            }
            case 2: {
                if (n == 2 || n == 3) break;
                throw new IllegalArgumentException("Invalid position for Bound style");
            }
            default: {
                throw new IllegalArgumentException("Invalid notebook style");
            }
        }
        this.side = n;
        this.look = n2;
    }

    private void rearrainge() {
        Component[] componentArray = this.getComponents();
        this.layout();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].layout();
                componentArray[n].repaint();
                ++n;
            }
        }
        this.repaint();
    }

    public void addPage(Object object, Component component, pageverifier pageverifier2) {
        this.addPage(object, Color.lightGray, Color.black, component, pageverifier2);
    }

    public void addPage(Object object, Color color, Component component, pageverifier pageverifier2) {
        this.addPage(object, color, Color.black, component, pageverifier2);
    }

    public void addPage(Object object, Color color, Color color2, Component component, pageverifier pageverifier2) {
        int n = this.pageLocation(object);
        int n2 = 0;
        int n3 = 0;
        if (n < 0) {
            this.tabs.addElement(object);
            this.bgColors.addElement(color);
            this.fgColors.addElement(color2);
            this.counts.addElement(new Integer(0));
            n = this.tabs.size() - 1;
            n2 = 1;
        } else {
            n2 = (Integer)this.counts.elementAt(n) + 1;
        }
        this.counts.setElementAt(new Integer(n2), n);
        n3 = this.linearIndex(n, n2);
        ++this.pageCounter;
        if (n3 > this.components.size() - 1) {
            this.verifierList.addElement(pageverifier2);
            this.pageNames.addElement(new Integer(this.pageCounter));
            this.components.addElement(component);
        } else {
            this.verifierList.insertElementAt(pageverifier2, n3);
            this.pageNames.insertElementAt(new Integer(this.pageCounter), n3);
            this.components.insertElementAt(component, n3);
        }
        this.add(String.valueOf(this.pageCounter), component);
        this.showPage();
    }

    public void insertPage(Object object, int n, Object object2, Component component, pageverifier pageverifier2) {
        this.insertPage(object, n, object2, Color.lightGray, Color.black, component, pageverifier2);
    }

    public void insertPage(Object object, int n, Object object2, Color color, Component component, pageverifier pageverifier2) {
        this.insertPage(object, n, object2, color, Color.black, component, pageverifier2);
    }

    public void insertPage(Object object, int n, Object object2, Color color, Color color2, Component component, pageverifier pageverifier2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        if (object == null) {
            bl = true;
        } else {
            n2 = this.pageLocation(object);
            n4 = this.pageLocation(object2);
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid notebook page requested.");
            }
            if (n4 >= 0 && n4 != n2) {
                throw new IllegalArgumentException("Tab to insert already exists elsewhere.");
            }
            if (n4 == n2 && (n > (Integer)this.counts.elementAt(n2) || n < 0)) {
                throw new IllegalArgumentException("Invalid notebook page requested.");
            }
            if (n4 < 0) {
                ++n2;
                bl = true;
            } else {
                n5 = n + 1;
                n3 = this.linearIndex(n4, n5);
            }
        }
        if (bl) {
            if (n2 < this.tabs.size()) {
                this.tabs.insertElementAt(object2, n2);
                this.bgColors.insertElementAt(color, n2);
                this.fgColors.insertElementAt(color2, n2);
                this.counts.insertElementAt(new Integer(0), n2);
            } else {
                this.tabs.addElement(object2);
                this.bgColors.addElement(color);
                this.fgColors.addElement(color2);
                this.counts.addElement(new Integer(0));
            }
            n3 = this.linearIndex(n2, 1);
            n5 = 1;
        }
        this.counts.setElementAt(new Integer(n5), n2);
        ++this.pageCounter;
        this.verifierList.insertElementAt(pageverifier2, n3);
        this.pageNames.insertElementAt(new Integer(this.pageCounter), n3);
        this.components.insertElementAt(component, n3);
        this.add(String.valueOf(this.pageCounter), component);
        this.showPage();
        this.rearrainge();
    }

    public Object getTab() {
        Object var1_1 = null;
        if (this.currentTab < this.tabs.size()) {
            var1_1 = this.tabs.elementAt(this.currentTab);
        }
        return var1_1;
    }

    public Object getTab(int n) {
        if (n < 0 || n >= this.tabs.size()) {
            throw new IllegalArgumentException("Invalid notebook tab requested.");
        }
        return this.tabs.elementAt(n);
    }

    public int getPageInTab() {
        return this.currentPage;
    }

    private int pageLocation(Object object) {
        return this.tabs.indexOf(object);
    }

    private int linearIndex() {
        return this.linearIndex(this.currentTab, this.currentPage);
    }

    private int linearIndex(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 += ((Integer)this.counts.elementAt(n4)).intValue();
            ++n4;
        }
        return n3 + n2 - 1;
    }

    private pageverifier pageVerifier() {
        return (pageverifier)this.verifierList.elementAt(this.linearIndex());
    }

    private boolean okToFlip(Object object, int n) {
        pageverifier pageverifier2 = this.pageVerifier();
        boolean bl = true;
        if (pageverifier2 != null) {
            bl = pageverifier2.okToChangePage(object, n);
        }
        return bl;
    }

    public Insets insets() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = this.size();
        return this.renderer.insets(fontMetrics, dimension);
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = this.size();
        this.hsList = null;
        this.renderer.paintTheLook(graphics, fontMetrics, dimension);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = super.imageUpdate(image, n, n2, n3, n4, n5);
        if ((n & 0xA0) != 0) {
            this.rearrainge();
        }
        return bl;
    }

    protected void addHotSpot(int n, int n2, int n3, int n4, int n5, Object object) {
        hotspot hotspot2 = new hotspot(new Rectangle(n, n2, n3, n4), object, n5);
        if (this.hsList == null) {
            this.hsList = hotspot2;
            return;
        }
        this.hsList.add(hotspot2);
    }

    protected Object[] getTabs() {
        Object[] objectArray = new Object[this.tabs.size()];
        this.tabs.copyInto(objectArray);
        return objectArray;
    }

    protected Color[] getBgColors() {
        Object[] objectArray = new Color[this.bgColors.size()];
        this.bgColors.copyInto(objectArray);
        return objectArray;
    }

    protected Color[] getFgColors() {
        Object[] objectArray = new Color[this.fgColors.size()];
        this.fgColors.copyInto(objectArray);
        return objectArray;
    }

    protected int getCurrentTab() {
        return this.currentTab;
    }

    private void buildStatusBar() {
        if (this.counts.size() > 0 && this.renderer.statusLineSupported()) {
            boolean bl = false;
            boolean bl2 = false;
            int n = (Integer)this.counts.elementAt(this.currentTab);
            if (n > 1) {
                this.renderer.setPaging("Page " + this.currentPage + " of " + n);
            } else {
                this.renderer.setPaging(null);
            }
            if (n > 1 || this.currentTab < this.tabs.size() - 1) {
                bl2 = true;
            }
            if (this.currentPage > 1 || this.currentTab > 0) {
                bl = true;
            }
        }
    }

    private void showPage() {
        this.buildStatusBar();
        if (this.tabs.size() != 0) {
            int n = this.linearIndex();
            this.layout.show(this, this.pageNames.elementAt(n).toString());
            if (this.lastTop >= 0 && this.lastTop != n) {
                this.deliverEvent(new Event(this, 1001, this.pageShowing()));
            }
            this.lastTop = n;
        }
    }

    public String pageShowing() {
        return String.valueOf(this.tabs.elementAt(this.currentTab).toString()) + Separator + this.currentPage;
    }

    public void verifyPage() {
        this.okToFlip(this.tabs.elementAt(this.currentTab), this.currentPage);
    }

    private int verifiedPageRequest(Object object, int n) {
        int n2 = this.pageLocation(object);
        if (n2 >= 0 && (n < 1 || n > (Integer)this.counts.elementAt(n2))) {
            n2 = -1;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid notebook page requested.");
        }
        return n2;
    }

    public void turnToPage(Object object, int n) {
        int n2 = this.verifiedPageRequest(object, n);
        if (this.okToFlip(object, n)) {
            this.currentTab = n2;
            this.currentPage = n;
            this.showPage();
            if (this.getFont() != null) {
                this.rearrainge();
            }
        }
    }

    public void removePage(Object object, int n) {
        int n2 = this.verifiedPageRequest(object, n);
        int n3 = this.linearIndex(n2, n);
        this.remove((Component)this.components.elementAt(n3));
        if (this.components.size() == 1) {
            this.verifierList.removeAllElements();
            this.pageNames.removeAllElements();
            this.components.removeAllElements();
            this.tabs.removeAllElements();
            this.fgColors.removeAllElements();
            this.bgColors.removeAllElements();
            this.counts.removeAllElements();
            this.currentTab = 0;
            this.currentPage = 1;
            return;
        }
        int n4 = (Integer)this.counts.elementAt(n2) - 1;
        this.verifierList.removeElementAt(n3);
        this.pageNames.removeElementAt(n3);
        this.components.removeElementAt(n3);
        if (n4 == 0) {
            this.tabs.removeElementAt(n2);
            this.bgColors.removeElementAt(n2);
            this.fgColors.removeElementAt(n2);
            this.counts.removeElementAt(n2);
            if (this.currentTab == this.tabs.size()) {
                --this.currentTab;
            }
            this.currentPage = 1;
        } else {
            this.counts.setElementAt(new Integer(n4), n2);
        }
        while (this.currentPage > (Integer)this.counts.elementAt(this.currentTab)) {
            --this.currentPage;
        }
        this.showPage();
        this.rearrainge();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.hsList != null) {
            this.clicked = this.hsList.hit(n, n2);
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        hotspot hotspot2 = null;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (this.hsList != null) {
            hotspot2 = this.hsList.hit(n, n2);
        }
        if (hotspot2 == this.clicked && this.clicked != null) {
            switch (this.clicked.getType()) {
                case 0: {
                    n3 = (Integer)hotspot2.getReference();
                    n4 = 1;
                    bl = this.okToFlip(this.tabs.elementAt(n3), n4);
                    break;
                }
                case 1: {
                    this.renderer.scroll(-1);
                    this.repaint();
                    break;
                }
                case 2: {
                    this.renderer.scroll(1);
                    this.repaint();
                    break;
                }
                case 3: {
                    n3 = this.currentTab;
                    n4 = this.currentPage;
                    if (n4 == 1) {
                        if (n3 > 0) {
                            n4 = (Integer)this.counts.elementAt(--n3);
                        }
                    } else {
                        --n4;
                    }
                    bl = this.okToFlip(this.tabs.elementAt(n3), n4);
                    break;
                }
                case 4: {
                    n3 = this.currentTab;
                    n4 = this.currentPage;
                    if (n4 == (Integer)this.counts.elementAt(this.currentTab)) {
                        if (n3 < this.tabs.size() - 1) {
                            ++n3;
                            n4 = 1;
                        }
                    } else {
                        ++n4;
                    }
                    bl = this.okToFlip(this.tabs.elementAt(n3), n4);
                    break;
                }
            }
        }
        if (bl) {
            this.currentTab = n3;
            this.currentPage = n4;
            this.showPage();
            this.rearrainge();
        }
        this.clicked = null;
        return super.mouseUp(event, n, n2);
    }
}

