/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

public class guidesocket
extends Thread {
    static String copyright = "(c)Copyright IBM Corporation 1998";
    static String RPD_CLIENTMSG_SHOW = "SHOW";
    static String RPD_CLIENTMSG_ACK = "ACK";
    static String RPD_CLIENTMSG_CLOSE = "CLOSE";
    static String RPD_CLIENTMSG_INIT = "INIT,";
    static byte NO_FILE_FOUND_INDICATOR;
    static final char RPD_SHELLMSG_INIT = 'I';
    static final char RPD_SHELLMSG_ACK = 'A';
    static final char RPD_SHELLMSG_VIEW = 'Y';
    static final char RPD_SHELLMSG_NOVIEW = 'N';
    static final char RPD_SHELLMSG_ENABLE = 'E';
    static final char RPD_SHELLMSG_DISABLE = 'D';
    static final char RPD_SHELLMSG_HELP = 'H';
    static final char RPD_SHELLMSG_SHOWACK = 'S';
    boolean fAcknowledge;
    guide theGuide;
    protected ServerSocket listen_socket;
    Socket fileDataSocket;
    protected int rpd_port = 5001;
    protected int file_port = 5002;
    boolean fContinue;
    boolean fRPDRunning;
    boolean fRPDEnabled;
    Socket client_socket;

    public guidesocket(guide guide2) {
        this.theGuide = guide2;
        this.listen_socket = null;
        this.fContinue = true;
        this.fRPDRunning = false;
        this.fRPDEnabled = false;
        this.fileDataSocket = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.fRPDRunning = true;
        try {
            while (this.fContinue) {
                if (this.listen_socket == null) {
                    this.listen_socket = new ServerSocket(this.rpd_port);
                }
                try {
                    this.client_socket = this.listen_socket.accept();
                    this.parseMessage(this.client_socket);
                }
                catch (IOException iOException) {
                    System.out.println("Exception while listening 5001 -" + iOException);
                    if (!this.fContinue) continue;
                    try {
                        this.listen_socket.close();
                        this.listen_socket = null;
                    }
                    catch (IOException iOException2) {}
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not create ServerSocket -" + iOException);
        }
        System.out.println("guidesocket thread ending");
    }

    public boolean isRPDRunning() {
        return this.fRPDRunning;
    }

    public boolean isRPDEnabled() {
        return this.fRPDEnabled;
    }

    public void enableShell(boolean bl) {
        this.theGuide.enableShell(bl);
    }

    public void showRPDHelp() {
        this.theGuide.showHelp(3002);
    }

    public void rpdSetCatalog(String string) {
        String string2 = String.valueOf(RPD_CLIENTMSG_INIT) + string;
        System.out.println("rpdSetCatalog -" + string2);
        this.sendMessage(string2);
    }

    public void setRPDEnabled(boolean bl) {
        this.fRPDEnabled = bl;
        this.theGuide.refreshCatalog();
    }

    public void showRPDApp() {
        this.sendMessage(RPD_CLIENTMSG_SHOW);
    }

    public DataInputStream getFileInputStream(String string) {
        DataInputStream dataInputStream = null;
        boolean bl = true;
        try {
            if (this.fileDataSocket == null) {
                this.fileDataSocket = new Socket("", this.file_port);
            }
            while (bl) {
                bl = false;
                PrintStream printStream = new PrintStream(this.fileDataSocket.getOutputStream());
                dataInputStream = new DataInputStream(new BufferedInputStream(this.fileDataSocket.getInputStream()));
                System.out.println("Sending RPD update request for file -" + string);
                if (this.sendMessageToStream(printStream, string)) {
                    try {
                        if (!dataInputStream.markSupported()) {
                            System.out.println("Mark not supported for this input stream; could be trouble!");
                        }
                        dataInputStream.mark(500);
                        byte[] byArray = new byte[1];
                        dataInputStream.read(byArray, 0, 1);
                        if (byArray[0] == NO_FILE_FOUND_INDICATOR) {
                            dataInputStream.close();
                            dataInputStream = null;
                            this.fileDataSocket.close();
                            this.fileDataSocket = null;
                            continue;
                        }
                        dataInputStream.reset();
                    }
                    catch (Exception exception) {
                        System.out.println("Exception while listening for return message form RPD client-" + exception);
                        dataInputStream.close();
                        dataInputStream = null;
                        this.fileDataSocket.close();
                        this.fileDataSocket = null;
                    }
                    continue;
                }
                System.out.println("File request not sent successfully -" + string);
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot open socket to RPD Server 2 -" + exception);
        }
        return dataInputStream;
    }

    public void closeFileSocket() {
        if (this.fileDataSocket != null) {
            try {
                System.out.println("Closing File socket");
                this.fileDataSocket.close();
            }
            catch (IOException iOException) {
                System.out.println("Error closing socket");
            }
            this.fileDataSocket = null;
        }
    }

    public void close() {
        this.fContinue = false;
        if (this.isRPDRunning()) {
            this.sendMessage(RPD_CLIENTMSG_CLOSE);
        }
        this.fRPDRunning = false;
        if (this.listen_socket != null) {
            try {
                this.listen_socket.close();
                System.out.println("Closing ServerSocket:\n");
            }
            catch (IOException iOException) {
                System.out.println("Error closing ServerSocket socket: " + iOException);
            }
        }
        try {
            this.stop();
            return;
        }
        catch (SecurityException securityException) {
            System.out.println("Error stopping thread:\n");
            return;
        }
    }

    private boolean sendMessageToStream(PrintStream printStream, String string) {
        boolean bl = false;
        try {
            printStream.println(String.valueOf(string) + "\r");
            printStream.flush();
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("Exception caught: " + exception.getMessage());
        }
        return bl;
    }

    private boolean sendMessage(String string) {
        boolean bl = false;
        try {
            Socket socket = new Socket("", this.file_port);
            PrintStream printStream = new PrintStream(socket.getOutputStream());
            bl = this.sendMessageToStream(printStream, string);
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("(sendMessage)RPD Server not responding, ensure it is running." + exception);
        }
        return bl;
    }

    public boolean checkRPDRunning() {
        block4: {
            this.fAcknowledge = false;
            if (!this.sendMessage(RPD_CLIENTMSG_ACK)) break block4;
            try {
                int n = 0;
                while (n < 10) {
                    Thread.sleep(500L);
                    if (!this.fAcknowledge) {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.fAcknowledge;
    }

    public void parseMessage(Socket socket) {
        String string = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            try {
                string = dataInputStream.readLine();
                dataInputStream.close();
                switch (string.charAt(0)) {
                    case 'I': {
                        System.out.println("RPD init received");
                        this.theGuide.rpdInitComplete();
                        break;
                    }
                    case 'A': {
                        System.out.println("RPD acknowledge received");
                        this.fAcknowledge = true;
                        break;
                    }
                    case 'S': {
                        System.out.println("RPD Show acknowledge received");
                        this.theGuide.rpdShowComplete();
                        break;
                    }
                    case 'H': {
                        System.out.println("RPD help request received");
                        this.showRPDHelp();
                        break;
                    }
                    case 'E': {
                        System.out.println("RPD Enable request received");
                        this.enableShell(true);
                        break;
                    }
                    case 'D': {
                        System.out.println("RPD Disable request received");
                        this.enableShell(false);
                        break;
                    }
                    case 'Y': {
                        System.out.println("RPD Update enabled received");
                        this.setRPDEnabled(true);
                        break;
                    }
                    case 'N': {
                        System.out.println("RPD Update disabled received");
                        this.setRPDEnabled(false);
                        break;
                    }
                    default: {
                        System.out.println("Unidentified message recieved -" + string);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Problem reading form stream:" + exception);
            }
        }
        catch (Exception exception) {
            System.err.println("Problem creating DataInputStream:\n" + exception);
        }
        try {
            socket.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

