/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.RDN;

public class X500Name
implements Principal {
    private String dn;
    private RDN[] names;
    private static final int[] commonName_data = new int[]{2, 5, 4, 3};
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    public static final ObjectIdentifier commonName_oid = new ObjectIdentifier(commonName_data);
    public static final ObjectIdentifier countryName_oid = new ObjectIdentifier(countryName_data);
    public static final ObjectIdentifier localityName_oid = new ObjectIdentifier(localityName_data);
    public static final ObjectIdentifier orgName_oid = new ObjectIdentifier(orgName_data);
    public static final ObjectIdentifier orgUnitName_oid = new ObjectIdentifier(orgUnitName_data);
    public static final ObjectIdentifier stateName_oid = new ObjectIdentifier(stateName_data);
    public static final ObjectIdentifier streetAddress_oid = new ObjectIdentifier(streetAddress_data);
    public static final ObjectIdentifier title_oid = new ObjectIdentifier(title_data);
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    public static final ObjectIdentifier ipAddress_oid = new ObjectIdentifier(ipAddress_data);

    private X500Name(String string) {
        this.parseDN(string);
    }

    public X500Name(String string, String string2, String string3, String string4) throws IOException {
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string4));
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(localityName_oid, new DerValue(string4));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(stateName_oid, new DerValue(string5));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string6));
    }

    public X500Name(DerValue derValue) throws IOException {
        this(derValue.toDerInputStream());
    }

    public X500Name(DerInputStream derInputStream) throws IOException {
        this.parseDER(derInputStream);
    }

    public boolean equals(X500Name x500Name) {
        if (this == x500Name) {
            return true;
        }
        if (this.dn == null) {
            this.generateDN();
        }
        if (this.names.length != x500Name.names.length) {
            return false;
        }
        int n = 0;
        while (n < this.names.length) {
            if (!this.names[n].equals(x500Name.names[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String getString(DerValue derValue) throws IOException {
        String string = derValue.getAsString();
        if (string == null) {
            throw new IOException("not a DER string encoding, " + derValue.tag);
        }
        return string;
    }

    public String getCountry() throws IOException {
        DerValue derValue = this.findAttribute(countryName_oid);
        return this.getString(derValue);
    }

    public String getOrganization() throws IOException {
        DerValue derValue = this.findAttribute(orgName_oid);
        return this.getString(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue derValue = this.findAttribute(orgUnitName_oid);
        return this.getString(derValue);
    }

    public String getCommonName() throws IOException {
        DerValue derValue = this.findAttribute(commonName_oid);
        return this.getString(derValue);
    }

    public String getLocality() throws IOException {
        DerValue derValue = this.findAttribute(localityName_oid);
        return this.getString(derValue);
    }

    public String getState() throws IOException {
        DerValue derValue = this.findAttribute(stateName_oid);
        return this.getString(derValue);
    }

    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        DerValue derValue = null;
        int n = 0;
        while (n < this.names.length) {
            derValue = this.names[n].findAttribute(objectIdentifier);
            if (derValue != null) break;
            ++n;
        }
        return derValue;
    }

    private void parseDER(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSequence(5);
        this.names = new RDN[derValueArray.length];
        int n = 0;
        while (n < derValueArray.length) {
            this.names[n] = new RDN(derValueArray[n]);
            ++n;
        }
    }

    public void emit(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = 0;
        while (n < this.names.length) {
            this.names[n].emit(derOutputStream2);
            ++n;
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    private void parseDN(String string) {
    }

    private void generateDN() {
        String string = null;
        int n = this.names.length - 1;
        while (n >= 0) {
            string = string == null ? this.names[n].toString() : String.valueOf(string) + ", " + this.names[n].toString();
            --n;
        }
        this.dn = string;
    }

    static ObjectIdentifier intern(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier.equals(commonName_oid)) {
            return commonName_oid;
        }
        if (objectIdentifier.equals(countryName_oid)) {
            return countryName_oid;
        }
        if (objectIdentifier.equals(localityName_oid)) {
            return localityName_oid;
        }
        if (objectIdentifier.equals(stateName_oid)) {
            return stateName_oid;
        }
        if (objectIdentifier.equals(streetAddress_oid)) {
            return streetAddress_oid;
        }
        if (objectIdentifier.equals(orgName_oid)) {
            return orgName_oid;
        }
        if (objectIdentifier.equals(orgUnitName_oid)) {
            return orgUnitName_oid;
        }
        if (objectIdentifier.equals(title_oid)) {
            return title_oid;
        }
        if (objectIdentifier.equals(ipAddress_oid)) {
            return ipAddress_oid;
        }
        return objectIdentifier;
    }
}

