/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class MessageHeader {
    private String[] keys;
    private String[] values;
    private int nkeys;

    public MessageHeader() {
        this.grow();
    }

    public MessageHeader(InputStream inputStream) throws IOException {
        this.parseHeader(inputStream);
    }

    public String findValue(String string) {
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                return this.values[n];
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                return this.values[n];
            }
        }
        return null;
    }

    public String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.values[n];
    }

    public String findNextValue(String string, String string2) {
        boolean bl = false;
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                if (bl) {
                    return this.values[n];
                }
                if (this.values[n] != string2) continue;
                bl = true;
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                if (bl) {
                    return this.values[n];
                }
                if (this.values[n] != string2) continue;
                bl = true;
            }
        }
        return null;
    }

    public void print(PrintStream printStream) {
        int n = 0;
        while (n < this.nkeys) {
            if (this.keys[n] != null) {
                printStream.print(String.valueOf(this.keys[n]) + (this.values[n] != null ? ": " + this.values[n] : "") + "\r\n");
            }
            ++n;
        }
        printStream.print("\r\n");
        printStream.flush();
    }

    public void add(String string, String string2) {
        this.grow();
        this.keys[this.nkeys] = string;
        this.values[this.nkeys] = string2;
        ++this.nkeys;
    }

    public void prepend(String string, String string2) {
        this.grow();
        int n = this.nkeys;
        while (n > 0) {
            this.keys[n] = this.keys[n - 1];
            this.values[n] = this.values[n - 1];
            --n;
        }
        this.keys[0] = string;
        this.values[0] = string2;
        ++this.nkeys;
    }

    public void set(int n, String string, String string2) {
        this.grow();
        if (n < 0) {
            return;
        }
        if (n > this.nkeys) {
            this.add(string, string2);
            return;
        }
        this.keys[n] = string;
        this.values[n] = string2;
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] stringArray = new String[this.nkeys + 4];
            String[] stringArray2 = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, stringArray, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy(this.values, 0, stringArray2, 0, this.nkeys);
            }
            this.keys = stringArray;
            this.values = stringArray2;
        }
    }

    public void set(String string, String string2) {
        int n = this.nkeys;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(this.keys[n])) continue;
            this.values[n] = string2;
            return;
        }
        this.add(string, string2);
    }

    public void setIfNotSet(String string, String string2) {
        if (this.findValue(string) == null) {
            this.add(string, string2);
        }
    }

    public static String canonicalID(String string) {
        char c;
        if (string == null) {
            return "";
        }
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        while (n < n2 && ((c = string.charAt(n)) == '<' || c <= ' ')) {
            ++n;
            bl = true;
        }
        while (n < n2 && ((c = string.charAt(n2 - 1)) == '>' || c <= ' ')) {
            --n2;
            bl = true;
        }
        if (bl) {
            return string.substring(n, n2);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void parseHeader(InputStream inputStream) throws IOException {
        this.nkeys = 0;
        if (inputStream == null) {
            return;
        }
        char[] cArray = new char[10];
        int n = inputStream.read();
        while (n != 10 && n != 13 && n >= 0) {
            Object object;
            void var2_3;
            int n2;
            int n3;
            block18: {
                int n4;
                n3 = 0;
                n2 = -1;
                boolean bl = n > 32;
                var2_3[n3++] = (char)n;
                while ((n4 = inputStream.read()) >= 0) {
                    switch (n4) {
                        case 58: {
                            if (bl && n3 > 0) {
                                n2 = n3;
                            }
                            bl = false;
                            break;
                        }
                        case 9: {
                            n4 = 32;
                        }
                        case 32: {
                            bl = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            n = inputStream.read();
                            if (n4 == 13 && n == 10 && (n = inputStream.read()) == 13) {
                                n = inputStream.read();
                            }
                            if (n == 10 || n == 13 || n > 32) break block18;
                            n4 = 32;
                        }
                    }
                    if (n3 >= ((void)var2_3).length) {
                        object = new char[((void)var2_3).length * 2];
                        System.arraycopy(var2_3, 0, object, 0, n3);
                        Object object2 = object;
                    }
                    var2_3[n3++] = (char)n4;
                }
                n = -1;
            }
            while (n3 > 0 && var2_3[n3 - 1] <= 32) {
                --n3;
            }
            if (n2 <= 0) {
                object = null;
                n2 = 0;
            } else {
                object = String.copyValueOf((char[])var2_3, 0, n2);
                if (n2 < n3 && var2_3[n2] == 58) {
                    ++n2;
                }
                while (n2 < n3 && var2_3[n2] <= 32) {
                    ++n2;
                }
            }
            String string = n2 >= n3 ? new String() : String.copyValueOf((char[])var2_3, n2, n3 - n2);
            this.add((String)object, string);
        }
    }

    public String toString() {
        String string = super.toString();
        int n = 0;
        while (n < this.keys.length) {
            string = String.valueOf(string) + "{" + this.keys[n] + ": " + this.values[n] + "}";
            ++n;
        }
        return string;
    }
}

