/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class AudioDevice {
    private Vector streams;
    private byte[] ulaw;
    private int[] linear;
    private int dev;
    private static final int MSCLICK = 50;
    private static final int MSMARGIN = 16;
    private static final int BYTES_PER_SAMPLE = 1;
    private static final int SAMPLE_RATE = 8000;
    private static final int ULAW_BIAS = 132;
    private static final int ULAW_CLIP = 32635;
    private static final int[] ULAW_TAB;
    private static final int[] ULAW_LUT;
    public static final AudioDevice device;

    private native int audioOpen();

    private native void audioClose();

    private synchronized native void audioWrite(byte[] var1, int var2);

    private AudioDevice() {
        try {
            System.loadLibrary("mmedia");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("could not find/load the mmedia library");
        }
        this.streams = new Vector();
        int n = 400;
        this.ulaw = new byte[n];
        this.linear = new int[n];
    }

    public synchronized void openChannel(InputStream inputStream) {
        this.streams.insertElementAt(inputStream, 0);
        this.notify();
    }

    public synchronized void closeChannel(InputStream inputStream) {
        if (this.streams.removeElement(inputStream)) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public synchronized void open() {
        int n = 1;
        int n2 = 5;
        while (this.dev == 0) {
            this.dev = this.audioOpen();
            if (this.dev < 0) {
                System.out.println("no audio device");
                return;
            }
            if (this.dev != 0) continue;
            System.out.println("audio device busy (attempt " + n + " out of " + n2 + ")");
            if (this.streams.size() == 0 || ++n > n2) {
                this.closeStreams();
                return;
            }
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                this.closeStreams();
                return;
            }
        }
    }

    public synchronized void close() {
        if (this.dev != 0) {
            this.audioClose();
            this.dev = 0;
        }
        this.closeStreams();
    }

    private synchronized void mix() {
        int n = this.ulaw.length;
        byte[] byArray = this.ulaw;
        switch (this.streams.size()) {
            case 0: {
                int n2 = n;
                while (n2-- > 0) {
                    byArray[n2] = 127;
                }
                return;
            }
            case 1: {
                InputStream inputStream = (InputStream)this.streams.elementAt(0);
                int n3 = 0;
                try {
                    n3 = inputStream.read(byArray, 0, n);
                }
                catch (IOException iOException) {
                    n3 = -1;
                }
                if (n3 <= 0) {
                    this.streams.removeElementAt(0);
                    n3 = 0;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                while (n3 < n) {
                    byArray[n3] = 127;
                    ++n3;
                }
                return;
            }
        }
        int[] nArray = ULAW_TAB;
        int[] nArray2 = this.linear;
        int n4 = this.streams.size() - 1;
        InputStream inputStream = (InputStream)this.streams.elementAt(n4);
        int n5 = 0;
        try {
            n5 = inputStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            n5 = -1;
        }
        if (n5 <= 0) {
            this.streams.removeElementAt(n4);
            n5 = 0;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        int n6 = 0;
        while (n6 < n5) {
            nArray2[n6] = nArray[byArray[n6] & 0xFF];
            ++n6;
        }
        while (n5 < n) {
            nArray2[n5] = 0;
            ++n5;
        }
        while (n4-- > 0) {
            inputStream = (InputStream)this.streams.elementAt(n4);
            try {
                n5 = inputStream.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                n5 = -1;
            }
            if (n5 <= 0) {
                this.streams.removeElementAt(n4);
                n5 = 0;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            while (n5-- > 0) {
                int n7 = n5;
                nArray2[n7] = nArray2[n7] + nArray[byArray[n5] & 0xFF];
            }
        }
        int[] nArray3 = ULAW_LUT;
        n5 = n;
        while (n5-- > 0) {
            int n8;
            int n9;
            int n10 = nArray2[n5];
            if (n10 >= 0) {
                if (n10 > 32635) {
                    n10 = 32635;
                }
                n9 = nArray3[(n10 += 132) >> 7];
                n8 = n10 >> n9 + 3 & 0xF;
                n10 = (n9 << 4 | n8) ^ 0xFF;
            } else {
                if ((n10 = -n10) > 32635) {
                    n10 = 32635;
                }
                n9 = nArray3[(n10 += 132) >> 7];
                n8 = n10 >> n9 + 3 & 0xF;
                n10 = (n9 << 4 | n8) ^ 0x7F;
            }
            byArray[n5] = (byte)n10;
        }
    }

    private synchronized boolean waitForData() throws InterruptedException {
        if (this.streams.size() == 0) {
            this.close();
            this.wait();
            this.open();
            return true;
        }
        return false;
    }

    public void play() {
        try {
            long l = System.currentTimeMillis() - 16L;
            while (this.dev > 0) {
                if (this.waitForData()) {
                    l = System.currentTimeMillis() - 16L;
                }
                this.mix();
                this.audioWrite(this.ulaw, this.ulaw.length);
                long l2 = (l += 50L) - System.currentTimeMillis();
                if (l2 > 0L) {
                    Thread.currentThread();
                    Thread.sleep(l2);
                    continue;
                }
                l = System.currentTimeMillis() - 16L;
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void closeStreams() {
        Enumeration enumeration = this.streams.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((InputStream)enumeration.nextElement()).close();
            }
            catch (IOException iOException) {}
        }
        this.streams = new Vector();
    }

    public int openChannels() {
        return this.streams.size();
    }

    static {
        int[] nArray = new int[256];
        nArray[0] = -32124;
        nArray[1] = -31100;
        nArray[2] = -30076;
        nArray[3] = -29052;
        nArray[4] = -28028;
        nArray[5] = -27004;
        nArray[6] = -25980;
        nArray[7] = -24956;
        nArray[8] = -23932;
        nArray[9] = -22908;
        nArray[10] = -21884;
        nArray[11] = -20860;
        nArray[12] = -19836;
        nArray[13] = -18812;
        nArray[14] = -17788;
        nArray[15] = -16764;
        nArray[16] = -15996;
        nArray[17] = -15484;
        nArray[18] = -14972;
        nArray[19] = -14460;
        nArray[20] = -13948;
        nArray[21] = -13436;
        nArray[22] = -12924;
        nArray[23] = -12412;
        nArray[24] = -11900;
        nArray[25] = -11388;
        nArray[26] = -10876;
        nArray[27] = -10364;
        nArray[28] = -9852;
        nArray[29] = -9340;
        nArray[30] = -8828;
        nArray[31] = -8316;
        nArray[32] = -7932;
        nArray[33] = -7676;
        nArray[34] = -7420;
        nArray[35] = -7164;
        nArray[36] = -6908;
        nArray[37] = -6652;
        nArray[38] = -6396;
        nArray[39] = -6140;
        nArray[40] = -5884;
        nArray[41] = -5628;
        nArray[42] = -5372;
        nArray[43] = -5116;
        nArray[44] = -4860;
        nArray[45] = -4604;
        nArray[46] = -4348;
        nArray[47] = -4092;
        nArray[48] = -3900;
        nArray[49] = -3772;
        nArray[50] = -3644;
        nArray[51] = -3516;
        nArray[52] = -3388;
        nArray[53] = -3260;
        nArray[54] = -3132;
        nArray[55] = -3004;
        nArray[56] = -2876;
        nArray[57] = -2748;
        nArray[58] = -2620;
        nArray[59] = -2492;
        nArray[60] = -2364;
        nArray[61] = -2236;
        nArray[62] = -2108;
        nArray[63] = -1980;
        nArray[64] = -1884;
        nArray[65] = -1820;
        nArray[66] = -1756;
        nArray[67] = -1692;
        nArray[68] = -1628;
        nArray[69] = -1564;
        nArray[70] = -1500;
        nArray[71] = -1436;
        nArray[72] = -1372;
        nArray[73] = -1308;
        nArray[74] = -1244;
        nArray[75] = -1180;
        nArray[76] = -1116;
        nArray[77] = -1052;
        nArray[78] = -988;
        nArray[79] = -924;
        nArray[80] = -876;
        nArray[81] = -844;
        nArray[82] = -812;
        nArray[83] = -780;
        nArray[84] = -748;
        nArray[85] = -716;
        nArray[86] = -684;
        nArray[87] = -652;
        nArray[88] = -620;
        nArray[89] = -588;
        nArray[90] = -556;
        nArray[91] = -524;
        nArray[92] = -492;
        nArray[93] = -460;
        nArray[94] = -428;
        nArray[95] = -396;
        nArray[96] = -372;
        nArray[97] = -356;
        nArray[98] = -340;
        nArray[99] = -324;
        nArray[100] = -308;
        nArray[101] = -292;
        nArray[102] = -276;
        nArray[103] = -260;
        nArray[104] = -244;
        nArray[105] = -228;
        nArray[106] = -212;
        nArray[107] = -196;
        nArray[108] = -180;
        nArray[109] = -164;
        nArray[110] = -148;
        nArray[111] = -132;
        nArray[112] = -120;
        nArray[113] = -112;
        nArray[114] = -104;
        nArray[115] = -96;
        nArray[116] = -88;
        nArray[117] = -80;
        nArray[118] = -72;
        nArray[119] = -64;
        nArray[120] = -56;
        nArray[121] = -48;
        nArray[122] = -40;
        nArray[123] = -32;
        nArray[124] = -24;
        nArray[125] = -16;
        nArray[126] = -8;
        nArray[128] = 32124;
        nArray[129] = 31100;
        nArray[130] = 30076;
        nArray[131] = 29052;
        nArray[132] = 28028;
        nArray[133] = 27004;
        nArray[134] = 25980;
        nArray[135] = 24956;
        nArray[136] = 23932;
        nArray[137] = 22908;
        nArray[138] = 21884;
        nArray[139] = 20860;
        nArray[140] = 19836;
        nArray[141] = 18812;
        nArray[142] = 17788;
        nArray[143] = 16764;
        nArray[144] = 15996;
        nArray[145] = 15484;
        nArray[146] = 14972;
        nArray[147] = 14460;
        nArray[148] = 13948;
        nArray[149] = 13436;
        nArray[150] = 12924;
        nArray[151] = 12412;
        nArray[152] = 11900;
        nArray[153] = 11388;
        nArray[154] = 10876;
        nArray[155] = 10364;
        nArray[156] = 9852;
        nArray[157] = 9340;
        nArray[158] = 8828;
        nArray[159] = 8316;
        nArray[160] = 7932;
        nArray[161] = 7676;
        nArray[162] = 7420;
        nArray[163] = 7164;
        nArray[164] = 6908;
        nArray[165] = 6652;
        nArray[166] = 6396;
        nArray[167] = 6140;
        nArray[168] = 5884;
        nArray[169] = 5628;
        nArray[170] = 5372;
        nArray[171] = 5116;
        nArray[172] = 4860;
        nArray[173] = 4604;
        nArray[174] = 4348;
        nArray[175] = 4092;
        nArray[176] = 3900;
        nArray[177] = 3772;
        nArray[178] = 3644;
        nArray[179] = 3516;
        nArray[180] = 3388;
        nArray[181] = 3260;
        nArray[182] = 3132;
        nArray[183] = 3004;
        nArray[184] = 2876;
        nArray[185] = 2748;
        nArray[186] = 2620;
        nArray[187] = 2492;
        nArray[188] = 2364;
        nArray[189] = 2236;
        nArray[190] = 2108;
        nArray[191] = 1980;
        nArray[192] = 1884;
        nArray[193] = 1820;
        nArray[194] = 1756;
        nArray[195] = 1692;
        nArray[196] = 1628;
        nArray[197] = 1564;
        nArray[198] = 1500;
        nArray[199] = 1436;
        nArray[200] = 1372;
        nArray[201] = 1308;
        nArray[202] = 1244;
        nArray[203] = 1180;
        nArray[204] = 1116;
        nArray[205] = 1052;
        nArray[206] = 988;
        nArray[207] = 924;
        nArray[208] = 876;
        nArray[209] = 844;
        nArray[210] = 812;
        nArray[211] = 780;
        nArray[212] = 748;
        nArray[213] = 716;
        nArray[214] = 684;
        nArray[215] = 652;
        nArray[216] = 620;
        nArray[217] = 588;
        nArray[218] = 556;
        nArray[219] = 524;
        nArray[220] = 492;
        nArray[221] = 460;
        nArray[222] = 428;
        nArray[223] = 396;
        nArray[224] = 372;
        nArray[225] = 356;
        nArray[226] = 340;
        nArray[227] = 324;
        nArray[228] = 308;
        nArray[229] = 292;
        nArray[230] = 276;
        nArray[231] = 260;
        nArray[232] = 244;
        nArray[233] = 228;
        nArray[234] = 212;
        nArray[235] = 196;
        nArray[236] = 180;
        nArray[237] = 164;
        nArray[238] = 148;
        nArray[239] = 132;
        nArray[240] = 120;
        nArray[241] = 112;
        nArray[242] = 104;
        nArray[243] = 96;
        nArray[244] = 88;
        nArray[245] = 80;
        nArray[246] = 72;
        nArray[247] = 64;
        nArray[248] = 56;
        nArray[249] = 48;
        nArray[250] = 40;
        nArray[251] = 32;
        nArray[252] = 24;
        nArray[253] = 16;
        nArray[254] = 8;
        ULAW_TAB = nArray;
        int[] nArray2 = new int[256];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 2;
        nArray2[5] = 2;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 3;
        nArray2[10] = 3;
        nArray2[11] = 3;
        nArray2[12] = 3;
        nArray2[13] = 3;
        nArray2[14] = 3;
        nArray2[15] = 3;
        nArray2[16] = 4;
        nArray2[17] = 4;
        nArray2[18] = 4;
        nArray2[19] = 4;
        nArray2[20] = 4;
        nArray2[21] = 4;
        nArray2[22] = 4;
        nArray2[23] = 4;
        nArray2[24] = 4;
        nArray2[25] = 4;
        nArray2[26] = 4;
        nArray2[27] = 4;
        nArray2[28] = 4;
        nArray2[29] = 4;
        nArray2[30] = 4;
        nArray2[31] = 4;
        nArray2[32] = 5;
        nArray2[33] = 5;
        nArray2[34] = 5;
        nArray2[35] = 5;
        nArray2[36] = 5;
        nArray2[37] = 5;
        nArray2[38] = 5;
        nArray2[39] = 5;
        nArray2[40] = 5;
        nArray2[41] = 5;
        nArray2[42] = 5;
        nArray2[43] = 5;
        nArray2[44] = 5;
        nArray2[45] = 5;
        nArray2[46] = 5;
        nArray2[47] = 5;
        nArray2[48] = 5;
        nArray2[49] = 5;
        nArray2[50] = 5;
        nArray2[51] = 5;
        nArray2[52] = 5;
        nArray2[53] = 5;
        nArray2[54] = 5;
        nArray2[55] = 5;
        nArray2[56] = 5;
        nArray2[57] = 5;
        nArray2[58] = 5;
        nArray2[59] = 5;
        nArray2[60] = 5;
        nArray2[61] = 5;
        nArray2[62] = 5;
        nArray2[63] = 5;
        nArray2[64] = 6;
        nArray2[65] = 6;
        nArray2[66] = 6;
        nArray2[67] = 6;
        nArray2[68] = 6;
        nArray2[69] = 6;
        nArray2[70] = 6;
        nArray2[71] = 6;
        nArray2[72] = 6;
        nArray2[73] = 6;
        nArray2[74] = 6;
        nArray2[75] = 6;
        nArray2[76] = 6;
        nArray2[77] = 6;
        nArray2[78] = 6;
        nArray2[79] = 6;
        nArray2[80] = 6;
        nArray2[81] = 6;
        nArray2[82] = 6;
        nArray2[83] = 6;
        nArray2[84] = 6;
        nArray2[85] = 6;
        nArray2[86] = 6;
        nArray2[87] = 6;
        nArray2[88] = 6;
        nArray2[89] = 6;
        nArray2[90] = 6;
        nArray2[91] = 6;
        nArray2[92] = 6;
        nArray2[93] = 6;
        nArray2[94] = 6;
        nArray2[95] = 6;
        nArray2[96] = 6;
        nArray2[97] = 6;
        nArray2[98] = 6;
        nArray2[99] = 6;
        nArray2[100] = 6;
        nArray2[101] = 6;
        nArray2[102] = 6;
        nArray2[103] = 6;
        nArray2[104] = 6;
        nArray2[105] = 6;
        nArray2[106] = 6;
        nArray2[107] = 6;
        nArray2[108] = 6;
        nArray2[109] = 6;
        nArray2[110] = 6;
        nArray2[111] = 6;
        nArray2[112] = 6;
        nArray2[113] = 6;
        nArray2[114] = 6;
        nArray2[115] = 6;
        nArray2[116] = 6;
        nArray2[117] = 6;
        nArray2[118] = 6;
        nArray2[119] = 6;
        nArray2[120] = 6;
        nArray2[121] = 6;
        nArray2[122] = 6;
        nArray2[123] = 6;
        nArray2[124] = 6;
        nArray2[125] = 6;
        nArray2[126] = 6;
        nArray2[127] = 6;
        nArray2[128] = 7;
        nArray2[129] = 7;
        nArray2[130] = 7;
        nArray2[131] = 7;
        nArray2[132] = 7;
        nArray2[133] = 7;
        nArray2[134] = 7;
        nArray2[135] = 7;
        nArray2[136] = 7;
        nArray2[137] = 7;
        nArray2[138] = 7;
        nArray2[139] = 7;
        nArray2[140] = 7;
        nArray2[141] = 7;
        nArray2[142] = 7;
        nArray2[143] = 7;
        nArray2[144] = 7;
        nArray2[145] = 7;
        nArray2[146] = 7;
        nArray2[147] = 7;
        nArray2[148] = 7;
        nArray2[149] = 7;
        nArray2[150] = 7;
        nArray2[151] = 7;
        nArray2[152] = 7;
        nArray2[153] = 7;
        nArray2[154] = 7;
        nArray2[155] = 7;
        nArray2[156] = 7;
        nArray2[157] = 7;
        nArray2[158] = 7;
        nArray2[159] = 7;
        nArray2[160] = 7;
        nArray2[161] = 7;
        nArray2[162] = 7;
        nArray2[163] = 7;
        nArray2[164] = 7;
        nArray2[165] = 7;
        nArray2[166] = 7;
        nArray2[167] = 7;
        nArray2[168] = 7;
        nArray2[169] = 7;
        nArray2[170] = 7;
        nArray2[171] = 7;
        nArray2[172] = 7;
        nArray2[173] = 7;
        nArray2[174] = 7;
        nArray2[175] = 7;
        nArray2[176] = 7;
        nArray2[177] = 7;
        nArray2[178] = 7;
        nArray2[179] = 7;
        nArray2[180] = 7;
        nArray2[181] = 7;
        nArray2[182] = 7;
        nArray2[183] = 7;
        nArray2[184] = 7;
        nArray2[185] = 7;
        nArray2[186] = 7;
        nArray2[187] = 7;
        nArray2[188] = 7;
        nArray2[189] = 7;
        nArray2[190] = 7;
        nArray2[191] = 7;
        nArray2[192] = 7;
        nArray2[193] = 7;
        nArray2[194] = 7;
        nArray2[195] = 7;
        nArray2[196] = 7;
        nArray2[197] = 7;
        nArray2[198] = 7;
        nArray2[199] = 7;
        nArray2[200] = 7;
        nArray2[201] = 7;
        nArray2[202] = 7;
        nArray2[203] = 7;
        nArray2[204] = 7;
        nArray2[205] = 7;
        nArray2[206] = 7;
        nArray2[207] = 7;
        nArray2[208] = 7;
        nArray2[209] = 7;
        nArray2[210] = 7;
        nArray2[211] = 7;
        nArray2[212] = 7;
        nArray2[213] = 7;
        nArray2[214] = 7;
        nArray2[215] = 7;
        nArray2[216] = 7;
        nArray2[217] = 7;
        nArray2[218] = 7;
        nArray2[219] = 7;
        nArray2[220] = 7;
        nArray2[221] = 7;
        nArray2[222] = 7;
        nArray2[223] = 7;
        nArray2[224] = 7;
        nArray2[225] = 7;
        nArray2[226] = 7;
        nArray2[227] = 7;
        nArray2[228] = 7;
        nArray2[229] = 7;
        nArray2[230] = 7;
        nArray2[231] = 7;
        nArray2[232] = 7;
        nArray2[233] = 7;
        nArray2[234] = 7;
        nArray2[235] = 7;
        nArray2[236] = 7;
        nArray2[237] = 7;
        nArray2[238] = 7;
        nArray2[239] = 7;
        nArray2[240] = 7;
        nArray2[241] = 7;
        nArray2[242] = 7;
        nArray2[243] = 7;
        nArray2[244] = 7;
        nArray2[245] = 7;
        nArray2[246] = 7;
        nArray2[247] = 7;
        nArray2[248] = 7;
        nArray2[249] = 7;
        nArray2[250] = 7;
        nArray2[251] = 7;
        nArray2[252] = 7;
        nArray2[253] = 7;
        nArray2[254] = 7;
        nArray2[255] = 7;
        ULAW_LUT = nArray2;
        device = new AudioDevice();
    }
}

